# 成绩自动录入助手

Chrome 浏览器插件，用于自动从 Excel 文件录入成绩到教务系统。

## 作者

- 作者：nongbin
- 邮箱：nongbin@tfswufe.edu.cn

## 安装步骤

1. 打开 Chrome 浏览器，地址栏输入 `chrome://extensions/`

2. 开启右上角的「开发者模式」

3. 点击左上角的「加载已解压的扩展程序」

4. 选择本文件夹 `grade-input-extension`

5. 插件安装成功！

## 功能说明

### 1. 上传成绩文件
点击或拖拽上传 Excel 成绩文件（支持 .xlsx 和 .xls 格式）

### 2. 开始录入成绩
上传 Excel 后，点击此按钮将成绩自动填入页面表单

### 3. 检查页面状态
检测当前页面是否已加载成绩录入表单，并显示检测到的输入框数量

### 4. 检查数据一致性
上传 Excel 文件后，检查 Excel 中的学号、姓名、成绩是否与页面中的数据一致
- 全部匹配：显示 "😊 学号、姓名、成绩已经全部核实"
- 有冲突：显示警告并自动下载冲突数据 Excel 文件

### 5. 一键清除成绩
无需上传文件，直接清除页面上所有已填写的成绩（按原顺序逐个清空）

## 使用方法

1. 打开成绩录入页面（登分表页面）

2. 点击浏览器工具栏上的插件图标

3. **录入成绩**：上传 Excel 文件后，点击「开始录入成绩」

4. **清除成绩**：直接点击「一键清除成绩」按钮

## Excel 文件要求

- 使用第一张工作表
- 成绩从第10行开始读取
- 总分在每行的最后一列
- B列：学号
- C列：姓名

## 文件说明

- `manifest.json` - 插件配置
- `popup.html` - 插件弹窗界面
- `popup.js` - 弹窗逻辑（处理Excel上传和解析）
- `content.js` - 注入页面的脚本（自动填表/清除）
- `background.js` - 后台服务
- `xlsx.full.min.js` - Excel解析库
