# 成绩自动录入助手 - 用户使用说明书

## 插件简介

成绩自动录入助手是一款 Chrome 浏览器插件，用于帮助教师快速从 Excel 文件录入成绩到教务系统成绩录入页面。

**联系邮箱：** nongbin@tfswufe.edu.cn

---

## 一、安装插件

### 步骤 1：打开扩展程序页面

1. 打开 Chrome 浏览器
2. 在地址栏输入 `chrome://extensions/`
3. 按 Enter 键进入扩展程序管理页面

### 步骤 2：启用开发者模式

在页面右上角，找到「开发者模式」开关，将其切换为**开启**状态。

### 步骤 3：加载插件

1. 点击左上角的「加载已解压的扩展程序」按钮
2. 在弹出的文件夹选择窗口中，选择 `grade-input-extension` 文件夹
3. 点击「确定」按钮

### 步骤 4：验证安装

插件安装成功后，浏览器工具栏（地址栏右侧）会显示插件图标。同时在扩展程序页面可以看到「成绩自动录入助手」已启用。

---

## 二、授权激活

首次使用插件时，需要输入授权码进行激活。

### 获取授权码

请通过邮箱联系作者获取授权码：`nongbin@tfswufe.edu.cn`

授权码有效期为 14 天，过期后需要重新获取。

### 输入授权码

1. 点击浏览器工具栏上的插件图标
2. 在弹出窗口中，输入获取到的授权码
3. 点击「验证授权」按钮
4. 验证通过后，即可使用插件的全部功能

---

## 三、Excel 文件要求

为确保插件正确读取成绩数据，请按以下要求准备 Excel 文件：

| 要求 | 说明 |
|------|------|
| 工作表 | 使用第一张工作表 |
| 数据起始行 | 从第 10 行开始读取成绩数据 |
| B 列 | 学生学号 |
| C 列 | 学生姓名 |
| 最后一列 | 学生总成绩 |

### Excel 格式示例

| A列（序号） | B列（学号） | C列（姓名） | ... | 最后一列（总分） |
|-------------|-------------|-------------|-----|-----------------|
| 1 | 2023001 | 张三 | ... | 95 |
| 2 | 2023002 | 李四 | ... | 88 |
| ... | ... | ... | ... | ... |

> **注意：** Excel 文件中的成绩数据应从第 10 行开始，前面 9 行可以是标题或其他信息。

---

## 四、使用方法

### 步骤 1：打开成绩录入页面

1. 登录教务系统
2. 进入成绩录入页面（登分表页面）
3. 等待页面完全加载完成

### 步骤 2：打开插件

点击浏览器工具栏上的「成绩自动录入助手」图标，弹出插件界面。

### 步骤 3：上传成绩文件

**方式一：点击上传**
1. 点击上传区域
2. 选择 Excel 文件（.xlsx 或 .xls 格式）

**方式二：拖拽上传**
1. 将 Excel 文件拖拽到上传区域
2. 释放鼠标即可上传

上传成功后，会显示文件名和读取到的成绩记录数量。

### 步骤 4：开始录入成绩

确认上传文件后，点击「开始录入成绩」按钮。

插件将自动：
1. 识别页面上的成绩输入框
2. 按顺序填入 Excel 中的成绩
3. 每个成绩间隔 100 毫秒填写，避免页面反应不及

### 步骤 5：检查结果（可选）

#### 检查页面状态
点击「检查页面状态」按钮，可以检测当前页面是否已加载成绩录入表单，并显示检测到的输入框数量。

#### 检查数据一致性
上传 Excel 文件后，点击「检查数据一致性」按钮，可以核对：
- Excel 中的学号与页面是否一致
- Excel 中的姓名与页面是否一致
- Excel 中的成绩与页面是否一致

**全部匹配：** 显示「学号、姓名、成绩已经全部核实」

**有冲突：** 显示冲突数量，并自动下载包含冲突详细信息的 Excel 文件（文件名格式：`数据冲突检查_时间戳.xlsx`）

### 步骤 6：一键清除成绩（可选）

如果需要清空已录入的成绩，直接点击「一键清除成绩」按钮，插件将按原顺序逐个清空所有成绩。

---

## 五、功能按钮说明

| 按钮 | 功能 | 使用时机 |
|------|------|----------|
| 开始录入成绩 | 将 Excel 中的成绩填入页面 | 上传 Excel 文件后 |
| 检查页面状态 | 检测页面上的成绩输入框数量 | 确认页面是否正确加载 |
| 检查数据一致性 | 对比 Excel 与页面的数据 | 录入成绩后核验 |
| 一键清除成绩 | 清空页面所有已填成绩 | 需要重新录入时 |

---

## 六、常见问题

### Q1：点击「开始录入成绩」后没有反应

**可能原因：**
- 不在成绩录入页面
- 页面尚未完全加载
- 插件未被授权

**解决方法：**
1. 确保在正确的成绩录入页面
2. 刷新页面后重试
3. 检查授权是否有效

### Q2：检测到的输入框数量为 0

**可能原因：**
- 页面结构不是标准的成绩录入页面
- 页面未完全加载

**解决方法：**
1. 刷新页面，等待完全加载
2. 确认打开的是正确的成绩录入页面

### Q3：部分成绩未录入

**可能原因：**
- Excel 文件中的学号/成绩列位置不正确
- 存在空行或格式问题

**解决方法：**
1. 使用「检查数据一致性」功能查看具体问题
2. 检查 Excel 文件格式是否符合要求

### Q4：授权码显示已过期

授权码有效期为 14 天，请联系作者获取新的授权码。

### Q5：数据不一致检查显示冲突

可能的原因：
- 页面数据已被手动修改
- Excel 文件不是最新的
- 页面顺序与 Excel 不一致

建议：下载冲突检查文件，核对具体冲突项后手动调整。

---

## 七、注意事项

1. **备份数据：** 录入成绩前，建议备份原始 Excel 文件
2. **核对确认：** 录入完成后，建议使用「检查数据一致性」功能确认
3. **页面稳定性：** 录入过程中请勿操作页面，等待完成
4. **授权有效期：** 关注授权码有效期，及时续期
5. **系统兼容性：** 本插件仅适用于标准结构的成绩录入页面

---

## 八、技术支持

如有问题或建议，请联系作者：

**邮箱：** nongbin@tfswufe.edu.cn

---

*最后更新：2024年12月*
